<?php
$user = $_SESSION['username'] ?? '';
$role = $_SESSION['role'] ?? '';
?>

<header class="app-header">
  <div class="header-left">
    <span class="brand">SIKAP</span>

    <span class="desc">
     <b>Selamat Datang Di Sistem Informasi Kinerja Aktivitas Pegawai</b>
    </span>
  </div>

  <div class="header-right">
    <span class="user-badge">
      <i class="fa-solid fa-user"></i>
      <?= htmlspecialchars($user) ?>
      <em><?= htmlspecialchars($role) ?></em>
    </span>
  </div>
</header>

<style>
/* ===== HEADER MODERN (STICKY) ===== */
.app-header{
  position:sticky;      /* 🔥 header tetap saat scroll */
  top:0;
  z-index:100;

  margin-bottom:-5px;
  padding:12px 18px;
  display:flex;
  justify-content:space-between;
  align-items:center;
  font-size:13px;
  background:rgba(255,255,255,.92);
  backdrop-filter: blur(6px);
  border-radius:0 0 6px 6px;
  box-shadow:0 2px 14px rgba(0,0,0,.06);
  color:#000000;
}

/* kiri */
.header-left{
  display:flex;
  align-items:center;
  gap:28px;
}

.header-left .brand{
  font-weight:600;
  letter-spacing:1px;
  color:#1f7ed7;
}

.header-left .desc{
  display:flex;
  align-items:center;
  gap:6px;
  opacity:.7;
  border-left:1px solid rgba(0,0,0,.08);
  padding-left:8px;
}

/* kanan */
.header-right{
  display:flex;
  align-items:center;
  gap:14px;
  white-space:nowrap;
}

/* badge user (SAMA dengan footer) */
.user-badge{
  display:flex;
  align-items:center;
  gap:6px;
  padding:4px 10px;
  border-radius:999px;
  background:linear-gradient(135deg,#1f7ed7,#2bb5a9);
  color:#fff;
  font-weight:500;
}

.user-badge i{
  font-size:10px;
  opacity:.9;
}

.user-badge em{
  font-style:normal;
  opacity:.85;
  font-size:10px;
}

.user-badge:hover{
  filter:brightness(1.05);
}

/* mobile */
@media (max-width:640px){
  .app-header{
    flex-direction:column;
    gap:6px;
    text-align:center;
  }
  .header-left .desc{
    display:none;
  }
}
</style>
