<?php
require_once 'config.php';

/* ================= HANDLER ================= */
if($_SERVER['REQUEST_METHOD'] === 'POST'){

  if($_POST['action']==='add'){
    $name = trim($_POST['name']);
    if($name!==''){
      // Cek unik (case-insensitive)
      $chk = mysqli_prepare($conn, "SELECT id FROM employees WHERE LOWER(name)=LOWER(?) LIMIT 1");
      mysqli_stmt_bind_param($chk, "s", $name);
      mysqli_stmt_execute($chk);
      mysqli_stmt_store_result($chk);
      $exists = mysqli_stmt_num_rows($chk) > 0;
      mysqli_stmt_close($chk);

      if($exists){
        // set flag error lalu redirect
        echo "<script>localStorage.setItem('peg_error','duplicate');location='?page=master_pegawai'</script>";
        exit;
      }

      $q = mysqli_prepare($conn,"INSERT INTO employees(name) VALUES(?)");
      mysqli_stmt_bind_param($q,"s",$name);
      mysqli_stmt_execute($q);
      mysqli_stmt_close($q);
    }
    echo "<script>location='?page=master_pegawai'</script>"; exit;
  }

  if($_POST['action']==='edit'){
    $id   = (int)$_POST['id'];
    $name = trim($_POST['name']);
    if($id>0 && $name!==''){
      // Cek unik (case-insensitive) pada id lain
      $chk = mysqli_prepare($conn, "SELECT id FROM employees WHERE LOWER(name)=LOWER(?) AND id <> ? LIMIT 1");
      mysqli_stmt_bind_param($chk, "si", $name, $id);
      mysqli_stmt_execute($chk);
      mysqli_stmt_store_result($chk);
      $exists = mysqli_stmt_num_rows($chk) > 0;
      mysqli_stmt_close($chk);

      if($exists){
        // set flag error lalu redirect
        echo "<script>localStorage.setItem('peg_error','duplicate_edit');location='?page=master_pegawai'</script>";
        exit;
      }

      $q = mysqli_prepare($conn,"UPDATE employees SET name=? WHERE id=?");
      mysqli_stmt_bind_param($q,"si",$name,$id);
      mysqli_stmt_execute($q);
      mysqli_stmt_close($q);
    }
    echo "<script>location='?page=master_pegawai'</script>"; exit;
  }

  if($_POST['action']==='delete'){
    $id = (int)$_POST['id'];

    // Ambil nama pegawai dulu (untuk pengecekan berbasis nama bila diperlukan)
    $qname = mysqli_prepare($conn, "SELECT name FROM employees WHERE id = ?");
    mysqli_stmt_bind_param($qname, "i", $id);
    mysqli_stmt_execute($qname);
    $resName = mysqli_stmt_get_result($qname);
    $rowName = mysqli_fetch_assoc($resName);
    mysqli_stmt_close($qname);

    $employee_name = $rowName['name'] ?? null;

    $in_use = false;

    if ($employee_name !== null) {
      // Daftar kolom kandidat yang sering dipakai untuk menyimpan referensi pegawai di tabel activity_master
      $candidates = [
        'employee_id','employee','employee_name','pic','assigned_to','responsible',
        'created_by','user_id','user_name','pegawai_id','pegawai_name'
      ];

      foreach ($candidates as $col) {
        // cek apakah kolom ini ada di activity_master
        $chkcol = mysqli_prepare($conn,
          "SELECT 1 FROM information_schema.columns
           WHERE table_schema = DATABASE() AND table_name = 'activity_master' AND column_name = ? LIMIT 1");
        mysqli_stmt_bind_param($chkcol, "s", $col);
        mysqli_stmt_execute($chkcol);
        mysqli_stmt_store_result($chkcol);
        $col_exists = mysqli_stmt_num_rows($chkcol) > 0;
        mysqli_stmt_close($chkcol);

        if ($col_exists) {
          // Jika kolom berakhiran _id atau bernama *_id, cek berdasarkan id numerik
          if (preg_match('/(_id$|^user_id$|^employee_id$|^pegawai_id$)/i', $col)) {
            // safe: $col berasal dari whitelist $candidates
            $query = "SELECT 1 FROM activity_master WHERE `$col` = ? LIMIT 1";
            $chk = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param($chk, "i", $id);
            mysqli_stmt_execute($chk);
            mysqli_stmt_store_result($chk);
            $used = mysqli_stmt_num_rows($chk) > 0;
            mysqli_stmt_close($chk);
            if ($used) { $in_use = true; break; }
          } else {
            // cek berdasarkan nama (case-insensitive)
            // safe: $col berasal dari whitelist $candidates
            $query = "SELECT 1 FROM activity_master WHERE LOWER(`$col`) = LOWER(?) LIMIT 1";
            $chk = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param($chk, "s", $employee_name);
            mysqli_stmt_execute($chk);
            mysqli_stmt_store_result($chk);
            $used = mysqli_stmt_num_rows($chk) > 0;
            mysqli_stmt_close($chk);
            if ($used) { $in_use = true; break; }
          }
        }
      }
    }

    if ($in_use) {
      // Kembalikan ke UI menggunakan mekanisme localStorage yang sudah ada
      echo "<script>
        localStorage.setItem('peg_error','in_use');
        location='?page=master_pegawai';
      </script>";
      exit;
    }

    // Jika tidak dipakai, lakukan delete
    $q = mysqli_prepare($conn,"DELETE FROM employees WHERE id=?");
    mysqli_stmt_bind_param($q,"i",$id);
    mysqli_stmt_execute($q);
    mysqli_stmt_close($q);
    echo "<script>location='?page=master_pegawai'</script>"; exit;
  }
}

/* ================= DATA ================= */
$res = mysqli_query($conn,"SELECT * FROM employees ORDER BY id DESC");
$total = mysqli_num_rows($res);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Master Pegawai</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<!-- SweetAlert2 untuk popup sukses/konfirmasi -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body{ background:#f4f6f9; font-size:12px; }
.container{
  width:100%;
  max-width: min(3840px, 98vw);
  padding-left:12px;
  padding-right:12px;
}
/* CARD COMPACT style (mirip master tim) */
.card-compact{
  border-radius:10px;
  box-shadow:0 3px 10px rgba(0,0,0,0.05);
}

/* ===== TABLE ===== */
.table{ font-size:12px; }
.table th, .table td { padding:6px 8px !important; vertical-align:middle; }
.table thead th{
  background:#0d6efd; /* biru seperti master tim */
  color:#fff;
  border-color:transparent;
}

/* tombol aksi kecil seperti master tim */
.btn-action{
  padding:5px 9px;
  font-size:11px;
  line-height:1;
  border-radius:5px;
}
.btn-action i{ font-size:11px; }

/* ===== EDIT POPUP DARI ATAS (fixed) =====
   ukuran & gaya diusahakan serupa Master Tim (lebar ~520px)
*/
#editBackdrop{
  position: fixed;
  inset: 0;
  background: rgba(0,0,0,0.32);
  z-index: 1040;
  display: none;
}
#editBox{
  position: fixed;
  top: -260px; /* start di atas */
  left: 50%;
  transform: translateX(-50%);
  width: 520px;
  max-width: 95%;
  z-index: 1060;
  opacity: 0;
  transition: all 0.36s cubic-bezier(.2,.9,.2,1);
  border-radius: 10px;
  background: #fff;
  box-shadow: 0 10px 28px rgba(11,63,135,0.12);
}
#editBox.show{
  top: 28px;
  opacity: 1;
}

/* inner form spacing */
#editBox .input-group-text{ padding:6px 10px; }
#editBox .form-control{ padding:6px 8px; }

/* animasi success SweetAlert */
@keyframes swal-pop {
  0% { transform: scale(0.5); opacity: 0; }
  60% { transform: scale(1.12); opacity: 1; }
  100% { transform: scale(1); opacity: 1; }
}
.swal-success .swal2-success { animation: swal-pop 420ms cubic-bezier(.2,.9,.2,1); }

@media (max-width:576px){
  #editBox{ width: 94%; left: 50%; transform: translateX(-50%); }
}
</style>
</head>
<body>

<div class="container mt-3">

<!-- TITLE -->
<div class="d-flex align-items-center mb-2">
  <i class="fa-solid fa-user-group fa-2x text-primary me-3"></i>
  <h3 class="mb-0 fw-semibold">Master Pegawai</h3>
</div>

<!-- FORM TAMBAH -->
<form id="addForm" method="post" class="row g-1 mb-1">
  <input type="hidden" name="action" value="add">

  <div class="col-md-3">
    <div class="input-group input-group-sm card-compact">
      <span class="input-group-text">
        <i class="fa-solid fa-user"></i>
      </span>
      <input
        type="text"
        name="name"
        class="form-control"
        placeholder="Nama Pegawai"
        required
      >
    </div>
  </div>

  <!-- TOMBOL TAMBAH (DIPERKECIL) -->
  <div class="col-auto d-flex align-items-center">
    <button type="submit" class="btn btn-primary btn-sm px-2">
      <i class="fa-solid fa-circle-plus me-1"></i> Tambah
    </button>
  </div>
</form>



<!-- TABLE -->
<div class="table-responsive">
<table class="table table-bordered table-hover mb-0">
<thead class="text-center">
<tr>
<th width="60">No</th>
<th>Nama Pegawai</th>
<th width="140">Aksi</th>
</tr>
</thead>
<tbody>

<?php if($total==0): ?>
<tr>
<td colspan="3" class="text-center text-muted py-4">Belum ada pegawai</td>
</tr>
<?php else: ?>

<?php $i=1; while($e=mysqli_fetch_assoc($res)): ?>
<tr>
<td class="text-center"><?= $i++ ?></td>
<td><?= htmlspecialchars($e['name']) ?></td>
<td class="text-center">

<!-- Edit: gunakan tombol kecil dengan icon FA -->
<!-- PERBAIKAN: ubah atribut onclick menjadi single-quoted agar json_encode string (double-quoted) tidak merusak atribut -->
<button class="btn btn-outline-primary btn-action me-1"
  onclick='showEdit(<?= (int)$e['id'] ?>, <?= json_encode($e['name']) ?> )'>
  <i class="fa-solid fa-pen"></i>
</button>

<!-- Delete: beri class delete-form agar JS menggantikan confirm() -->
<form method="post" style="display:inline" class="delete-form">
<input type="hidden" name="action" value="delete">
<input type="hidden" name="id" value="<?= (int)$e['id'] ?>">
<button class="btn btn-outline-danger btn-action" type="button" onclick="confirmDelete(this)">
  <i class="fa-solid fa-trash"></i>
</button>
</form>

</td>
</tr>
<?php endwhile; ?>

<?php endif; ?>
</tbody>
</table>
</div>

<!-- EDIT (fixed popup dari atas) -->
<div id="editBackdrop"></div>

<div id="editBox" style="display:none;">
  <div class="p-3">
    <h6 class="mb-2"><i class="fa-solid fa-pen-to-square text-success"></i> Edit Pegawai</h6>
    <form id="editForm" method="post" class="row g-2">
      <input type="hidden" name="action" value="edit">
      <input type="hidden" name="id" id="eid">

      <div class="col-9">
        <div class="input-group">
          <span class="input-group-text"><i class="fa-solid fa-user"></i></span>
          <input name="name" id="ename" class="form-control" required>
        </div>
      </div>

      <div class="col-3 d-grid">
        <button class="btn btn-success">Simpan</button>
      </div>
    </form>
  </div>
</div>

</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
/* ===== Pembantu & elemen ===== */
const editBox = document.getElementById('editBox');
const editBackdrop = document.getElementById('editBackdrop');
const eid = document.getElementById('eid');
const ename = document.getElementById('ename');

// tampilkan popup edit dari atas
function showEdit(id, name){
  eid.value = id;
  ename.value = name;
  // tampilkan backdrop + popup slide down
  editBackdrop.style.display = 'block';
  editBox.style.display = 'block';
  // beri jeda agar transition bekerja
  setTimeout(()=> editBox.classList.add('show'), 10);
  // fokus input setelah animasi
  setTimeout(()=> ename.focus(), 220);
}

// sembunyikan popup edit
function hideEdit(){
  editBox.classList.remove('show');
  setTimeout(()=>{
    editBox.style.display = 'none';
    editBackdrop.style.display = 'none';
  }, 380);
}

// klik backdrop menutup popup
editBackdrop.addEventListener('click', hideEdit);
document.addEventListener('keydown', function(e){
  if(e.key === 'Escape' && editBox.style.display === 'block') hideEdit();
});

/* ===== Notifikasi SweetAlert2 setelah aksi =====
   Karena server melakukan redirect setelah POST tanpa flag,
   kita set localStorage sebelum submit (client-side) dan membaca
   flag ini pada load untuk menampilkan popup sukses/error.

   CATATAN: server dapat men-set peg_error jika mendeteksi duplikat atau in_use.
   Saat reload, kita prioritaskan menampilkan pesan ERROR jika ada,
   lalu baru pesan sukses.
*/

// ADD: intercept addForm submit, set flag lalu biarkan submit biasa
const addForm = document.getElementById('addForm');
addForm.addEventListener('submit', function(e){
  // set flag untuk popup sukses setelah reload (dapat ditimpa oleh server peg_error)
  try { localStorage.setItem('peg_notif','added'); } catch(e){}
  // lanjutkan submit form secara normal
});

// EDIT: intercept editForm submit, set flag lalu biarkan submit
const editForm = document.getElementById('editForm');
editForm.addEventListener('submit', function(e){
  try { localStorage.setItem('peg_notif','updated'); } catch(err){}
  // form dikirim ke server
});

// DELETE: gunakan SweetAlert2 konfirmasi, kemudian set flag dan submit form
function confirmDelete(button){
  // cari elemen form induk
  let form = button.closest('form');
  if(!form) return;
  Swal.fire({
    title: 'Yakin ingin menghapus?',
    text: 'Data pegawai akan dihapus secara permanen.',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Ya, hapus',
    cancelButtonText: 'Batal',
    confirmButtonColor: '#d33',
    reverseButtons: false,
    focusCancel: true
  }).then((result) => {
    if(result.isConfirmed){
      try { localStorage.setItem('peg_notif','deleted'); } catch(e){}
      // submit form (akan memicu delete server-side dan redirect)
      form.submit();
    }
  });
}

/* Saat halaman dimuat, tampilkan notifikasi bila flag ada (prioritaskan error) */
document.addEventListener('DOMContentLoaded', function(){
  try {
    const err = localStorage.getItem('peg_error');
    if(err){
      let text = '';
      if(err === 'duplicate') text = 'Nama pegawai sudah terdaftar. Gunakan nama lain.';
      else if(err === 'duplicate_edit') text = 'Nama pegawai sudah digunakan oleh pegawai lain.';
      else if(err === 'in_use') text = 'Pegawai tidak bisa dihapus karena sudah dipakai pada data aktivitas.';
      else text = 'Terjadi kesalahan.';

      Swal.fire({
        icon: 'error',
        title: 'Gagal',
        text: text,
        confirmButtonText: 'OK',
        confirmButtonColor: '#dc3545'
      });

      // hapus kedua flag (error + success) agar tidak menampilkan sukses juga
      localStorage.removeItem('peg_error');
      localStorage.removeItem('peg_notif');
      return;
    }

    const f = localStorage.getItem('peg_notif');
    if(f){
      let text='';
      if(f==='added') text = 'Pegawai berhasil ditambahkan.';
      else if(f==='updated') text = 'Pegawai berhasil diperbarui.';
      else if(f==='deleted') text = 'Pegawai berhasil dihapus.';

      Swal.fire({
        icon: 'success',
        title: 'Berhasil',
        text: text,
        showConfirmButton: false,
        timer: 1600,
        timerProgressBar: true,
        customClass: { popup: 'swal-success' }
      });

      localStorage.removeItem('peg_notif');
    }
  } catch(e){
    console.error(e);
  }
});
</script>

</body>
</html>