<?php
require_once 'config.php'; // pastikan $conn ada

// Handler logic (tidak diubah — hanya menambahkan localStorage flag sebelum redirect / pengecekan unik)
if($_SERVER['REQUEST_METHOD'] === 'POST'){

    /* ===== TAMBAH ===== */
    if(isset($_POST['action']) && $_POST['action']==='add'){
        $name = trim($_POST['name']);
        if($name !== ''){
            // Cek apakah nama tim sudah ada (case-insensitive)
            $chk = mysqli_prepare($conn, "SELECT id FROM teams WHERE LOWER(name) = LOWER(?) LIMIT 1");
            mysqli_stmt_bind_param($chk, "s", $name);
            mysqli_stmt_execute($chk);
            mysqli_stmt_store_result($chk);
            $exists = mysqli_stmt_num_rows($chk) > 0;
            mysqli_stmt_close($chk);

         if($exists){
    echo "<script>
        localStorage.setItem('notif_error','duplicate');
        window.location='?page=master_tim';
    </script>";
    exit;
}


            $q = mysqli_prepare($conn,"INSERT INTO teams(name) VALUES(?)");
            mysqli_stmt_bind_param($q,"s",$name);
            mysqli_stmt_execute($q);
            mysqli_stmt_close($q);
        }
        // set flag via JS sebelum redirect agar popup muncul setelah reload
        echo "<script>localStorage.setItem('notif','added');window.location='?page=master_tim';</script>";
        exit;
    }

    /* ===== EDIT ===== */
    if(isset($_POST['action']) && $_POST['action']==='edit'){
        $id   = (int)$_POST['id'];
        $name = trim($_POST['name']);

        if($name !== ''){
            // Cek apakah nama tim sudah ada pada ID lain (case-insensitive)
            $chk = mysqli_prepare($conn, "SELECT id FROM teams WHERE LOWER(name) = LOWER(?) AND id <> ? LIMIT 1");
            mysqli_stmt_bind_param($chk, "si", $name, $id);
            mysqli_stmt_execute($chk);
            mysqli_stmt_store_result($chk);
            $exists = mysqli_stmt_num_rows($chk) > 0;
            mysqli_stmt_close($chk);

           if($exists){
    echo "<script>
        localStorage.setItem('notif_error','duplicate_edit');
        window.location='?page=master_tim';
    </script>";
    exit;
}


            $q = mysqli_prepare($conn,"UPDATE teams SET name=? WHERE id=?");
            mysqli_stmt_bind_param($q,"si",$name,$id);
            mysqli_stmt_execute($q);
            mysqli_stmt_close($q);
        }
        echo "<script>localStorage.setItem('notif','updated');window.location='?page=master_tim';</script>";
        exit;
    }

    /* ===== DELETE (AMAN FK) ===== */
    if(isset($_POST['action']) && $_POST['action']==='delete'){
        $id = (int)$_POST['id'];

        $cek = mysqli_prepare($conn,"SELECT COUNT(*) FROM activity_master WHERE team_id=?");
        mysqli_stmt_bind_param($cek,"i",$id);
        mysqli_stmt_execute($cek);
        mysqli_stmt_bind_result($cek,$total);
        mysqli_stmt_fetch($cek);
        mysqli_stmt_close($cek);

        if($total > 0){
            echo "<script>
                alert('Tim tidak bisa dihapus karena masih digunakan oleh data aktivitas.');
                window.location='?page=master_tim';
            </script>";
            exit;
        }

        $q = mysqli_prepare($conn,"DELETE FROM teams WHERE id=?");
        mysqli_stmt_bind_param($q,"i",$id);
        mysqli_stmt_execute($q);
        mysqli_stmt_close($q);

        echo "<script>localStorage.setItem('notif','deleted');window.location='?page=master_tim';</script>";
        exit;
    }
}

$res = mysqli_query($conn,"SELECT * FROM teams ORDER BY name");
$total = mysqli_num_rows($res);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Master Tim</title>
<meta name="viewport" content="width=device-width,initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<!-- SweetAlert2 (untuk popup di tengah + animasi) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body{ background:#f4f6f9; font-size:12px; }
.container{
  width:100%;
  max-width: min(3840px, 98vw);
  padding-left:12px;
  padding-right:12px;
}
.card-compact{
  border-radius:10px;
  box-shadow:0 3px 10px rgba(0,0,0,0.05);
}

/* ===== TABLE COMPACT ===== */
.table{
  font-size:12px;
}
.table th, .table td{
  padding:6px 8px !important;
  vertical-align:middle;
}
.table thead th{
  background:#0d6efd;
  color:#fff;
  border-color:transparent;
}
.table tbody tr:hover{
  background:rgba(13,110,253,0.03);
}

/* ===== BUTTON AKSI KECIL ===== */
.btn-action{
  padding:4px 8px;
  font-size:11px;
}
.btn-action i{
  font-size:11px;
}

/* ===== INPUT & FORM ===== */
.input-group-text{
  padding:4px 8px;
}
.form-control{
  font-size:12px;
  padding:4px 8px;
}

.no-data{
  color:#6c757d;
  padding:30px 0;
  text-align:center;
}

/* ===== ANIMASI ICON SUCCESS (SweetAlert2) ===== */
@keyframes swal-pop {
  0% { transform: scale(0.5); opacity: 0; }
  60% { transform: scale(1.12); opacity: 1; }
  100% { transform: scale(1); opacity: 1; }
}
.swal-success .swal2-success {
  animation: swal-pop 420ms cubic-bezier(.2,.9,.2,1);
}

/* ===== EDIT POPUP DARI ATAS ===== */
#editBackdrop{
  position: fixed;
  inset: 0;
  background: rgba(0,0,0,0.35);
  z-index: 1040;
  display: none;
}
#editBox{
  position: fixed;
  top: -240px; /* start di atas layar */
  left: 50%;
  transform: translateX(-50%);
  width: 520px;
  max-width: 95%;
  z-index: 1060;
  opacity: 0;
  transition: all 0.35s cubic-bezier(.2,.9,.2,1);
  border-radius: 10px;
}
#editBox.show{
  top: 28px;
  opacity: 1;
  box-shadow: 0 8px 30px rgba(0,0,0,0.12);
}

/* kecilkan jarak internal karena posisi fixed */
#editBox .card-compact { margin: 0; }
</style>
</head>

<body>
<div class="container mt-3">

<!-- TITLE -->
<div class="d-flex align-items-center mb-3">
  <i class="fa-solid fa-users fa-2x text-primary me-3"></i>
  <h3 class="mb-0 fw-semibold">Master Tim</h3>
</div>

<!-- ADD (BAWAH KIRI) -->
<div class="row mb-2">
  <div class="col-md-5">
    <form method="post" class="row g-1">
      <input type="hidden" name="action" value="add">

      <div class="col-8">
        <div class="input-group input-group-sm card-compact">
          <span class="input-group-text">
            <i class="fa-solid fa-tag"></i>
          </span>
          <input
            name="name"
            class="form-control"
            placeholder="Tambah Tim"
            required
            id="addName"
          >
        </div>
      </div>

       <!-- TOMBOL TAMBAH (DIPERKECIL) -->
  <div class="col-auto d-flex align-items-center">
    <button type="submit" class="btn btn-primary btn-sm px-2">
      <i class="fa-solid fa-circle-plus me-1"></i> Tambah
    </button>
  </div>
    </form>
  </div>
</div>


<!-- TABLE -->
<div class="table-responsive">
<table class="table table-bordered table-hover align-middle mb-0" id="teamsTable">
<thead class="text-center">
<tr>
  <th width="50">No</th>
  <th>Nama Tim</th>
  <th width="120">Aksi</th>
</tr>
</thead>
<tbody>
<?php
$i=1;
while($r=mysqli_fetch_assoc($res)):
?>
<tr>
<td class="text-center"><?= $i++ ?></td>
<td class="team-name"><?= htmlspecialchars($r['name']) ?></td>
<td class="text-center">
  <div class="d-inline-flex gap-1">
    <button
      class="btn btn-outline-primary btn-action"
      onclick="showEdit(<?= (int)$r['id'] ?>,'<?= htmlspecialchars(addslashes($r['name'])) ?>')"
      title="Edit"
    >
      <i class="fa-solid fa-pen"></i>
    </button>

    <form method="post" class="delete-form m-0">
      <input type="hidden" name="action" value="delete">
      <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
      <button class="btn btn-outline-danger btn-action" title="Hapus">
        <i class="fa-solid fa-trash"></i>
      </button>
    </form>
  </div>
</td>

</tr>
<?php endwhile; ?>

<?php if($total===0): ?>
<tr>
<td colspan="3" class="no-data">
<i class="fa-regular fa-folder-open fa-lg mb-1"></i><br>
Belum ada tim
</td>
</tr>
<?php endif; ?>
</tbody>
</table>
</div>

<!-- EDIT (POSISI FIXED, AWALNYA HIDDEN) -->
<div id="editBackdrop"></div>

<div id="editBox" class="card card-compact p-3" style="display:none;">
  <h6 class="mb-2"><i class="fa-solid fa-pen-to-square text-success"></i> Edit Tim</h6>

  <form method="post" class="row g-2">
    <input type="hidden" name="action" value="edit">
    <input type="hidden" name="id" id="edit_id">

    <div class="col-9">
      <div class="input-group">
        <span class="input-group-text"><i class="fa-solid fa-tag"></i></span>
        <input name="name" id="edit_name" class="form-control" required>
      </div>
    </div>

    <div class="col-3 d-grid gap-1">
      <button class="btn btn-success btn-sm">Simpan</button>
    </div>
  </form>
</div>

</div>

<!-- Bootstrap JS (tetap dipertahankan) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
/* ===== EDIT POPUP DARI ATAS ===== */
const editBox = document.getElementById('editBox');
const editBackdrop = document.getElementById('editBackdrop');
const edit_id = document.getElementById('edit_id');
const edit_name = document.getElementById('edit_name');

function showEdit(id,name){
  // isi nilai form
  edit_id.value = id;
  edit_name.value = name;

  // tampilkan backdrop + popup dengan animasi slide down
  editBackdrop.style.display = 'block';
  editBox.style.display = 'block';
  // beri jeda kecil agar transition bekerja
  setTimeout(()=> editBox.classList.add('show'), 10);

  // fokus ke input setelah animasi
  setTimeout(()=> edit_name.focus(), 220);
}

function hideEdit(){
  // sembunyikan dengan animasi
  editBox.classList.remove('show');
  // sembunyikan backdrop setelah animasi selesai
  setTimeout(()=> {
    editBox.style.display = 'none';
    editBackdrop.style.display = 'none';
  }, 360);
}

// klik backdrop juga menutup popup
editBackdrop.addEventListener('click', hideEdit);
document.addEventListener('keydown', function(e){
  if(e.key === 'Escape' && editBox.style.display === 'block'){
    hideEdit();
  }
});

/* ===== KONFIRMASI HAPUS (SweetAlert2 di tengah layar) ===== */
document.addEventListener('DOMContentLoaded', function(){
  // tangani submit untuk form dengan class 'delete-form'
  document.querySelectorAll('form.delete-form').forEach(function(form){
    form.addEventListener('submit', function(ev){
      ev.preventDefault(); // cegah submit langsung
      // tampilkan SweetAlert2 confirm di tengah
      Swal.fire({
        title: 'Yakin ingin menghapus?',
        text: 'Data tim akan dihapus secara permanen.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Ya, hapus',
        cancelButtonText: 'Batal',
        confirmButtonColor: '#d33',
        reverseButtons: false,
        focusCancel: true
      }).then((result) => {
        if (result.isConfirmed) {
          // jika konfirmasi, submit form (server-side akan menjalankan delete)
          form.submit();
        }
        // jika batal, tidak melakukan apa-apa
      });
    }, false);
  });


  /* ===== SweetAlert2 popup sukses (setelah redirect menggunakan localStorage flag) ===== */
  try {
    const notif = localStorage.getItem('notif');
    if(notif){
      let text = '';
      if(notif === 'added')   text = 'Tim berhasil ditambahkan';
      if(notif === 'updated') text = 'Tim berhasil diperbarui';
      if(notif === 'deleted') text = 'Tim berhasil dihapus';

      Swal.fire({
        icon: 'success',
        title: 'Berhasil',
        text: text,
        showConfirmButton: false,
        timer: 1800,
        timerProgressBar: true,
        allowOutsideClick: false,
        customClass: { popup: 'swal-success' }
      });

      // hapus flag agar tidak muncul lagi
      localStorage.removeItem('notif');
    }
  } catch(e){
    console.error(e);
  }
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function(){

  /* ===== POPUP ERROR DATA DOBEL ===== */
  try {
    const err = localStorage.getItem('notif_error');
    if(err){
      let text = '';

      if(err === 'duplicate'){
        text = 'Nama tim sudah terdaftar. Gunakan nama lain.';
      }
      if(err === 'duplicate_edit'){
        text = 'Nama tim sudah digunakan oleh tim lain.';
      }

      Swal.fire({
        icon: 'error',
        title: 'Gagal',
        text: text,
        confirmButtonText: 'OK',
        confirmButtonColor: '#dc3545'
      });

      localStorage.removeItem('notif_error');
    }
  } catch(e){
    console.error(e);
  }

});
</script>


</body>
</html>
