<?php
require_once 'config.php';

function jsonOut($data){
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

if(isset($_GET['action']) && $_GET['action']=='list'){

    $month = $_GET['month'] ?? '';
    $search = $_GET['search'] ?? '';

    $conds=[]; $types=''; $params=[];

    if($month !== ''){
        $conds[]="am.month=?";
        $types.='i'; $params[]=(int)$month;
    }
    if($search !== ''){
        $conds[]="am.activity_name LIKE ?";
        $types.='s'; $params[]='%'.$search.'%';
    }

    $sql="SELECT am.id,am.activity_name,am.sub_activity_name,
          am.month,am.year,am.target_volume,
          IFNULL(SUM(de.volume_today),0) realisasi
          FROM activity_master am
          LEFT JOIN daily_entries de ON de.activity_master_id=am.id";

    if($conds) $sql.=" WHERE ".implode(' AND ',$conds);

    $sql.=" GROUP BY am.id ORDER BY am.year DESC,am.month DESC,am.activity_name";

    $stmt=mysqli_prepare($conn,$sql);
    if($types){
        $bind[]=$types;
        foreach($params as $k=>$v) $bind[]=&$params[$k];
        call_user_func_array([$stmt,'bind_param'],$bind);
    }

    mysqli_stmt_execute($stmt);
    $res=mysqli_stmt_get_result($stmt);
    $rows=[];
    while($r=mysqli_fetch_assoc($res)){
        $r['target_volume']=(int)$r['target_volume'];
        $r['realisasi']=(int)$r['realisasi'];
        $rows[]=$r;
    }
    jsonOut($rows);
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Target Kegiatan / Bulan</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
:root{
  --primary:#0d6efd;
}
body{
  font-size:13px;
  background:#f1f3f6;
}
.container{
  width:100%;
  max-width: min(3840px, 98vw);
  padding-left:12px;
  padding-right:12px;
}

/* title */
.page-title{
  display:flex;
  align-items:center;
  gap:10px;
  font-weight:600;
}

/* card */
.card{
  border:none;
  border-radius:12px;
  box-shadow:0 4px 14px rgba(0,0,0,.06);
}

/* filter */
.filter-wrap{
  display:flex;
  gap:8px;
  flex-wrap:wrap;
}
.filter-wrap select,
.filter-wrap input{
  padding:6px 10px;
  border-radius:8px;
  border:1px solid #ddd;
}

/* custom select arrow */
select{
  appearance:none;
  -webkit-appearance:none;
  -moz-appearance:none;
  background-image:
    linear-gradient(45deg, transparent 50%, #999 50%),
    linear-gradient(135deg, #999 50%, transparent 50%);
  background-position:
    calc(100% - 18px) 50%,
    calc(100% - 12px) 50%;
  background-size:6px 6px;
  background-repeat:no-repeat;
}
/* luruskan header dengan tabel */
.header-bar{
  margin-left:-2px;   /* geser dikit ke kiri */
  margin-right:-2px;
  padding-right:2px;
}

/* filter box modern */
.header-right{
  background:#ffffff;
  border:1px solid #e2e2e2;
  border-radius:10px;
  padding:4px;
  display:flex;
  align-items:center;
  gap:4px;
  box-shadow:0 2px 6px rgba(0,0,0,.04);
}

.header-right .filter-item{
  display:flex;
  align-items:center;
  gap:6px;
  padding:4px 8px;
  background:#f8f9fc;
  border-radius:8px;
}

.header-right i{
  color:#6c757d;
  font-size:13px;
}

.header-right select,
.header-right input{
  border:none;
  background:transparent;
  outline:none;
  height:24px;
  font-size:12px;
  padding:0;
}

.header-right input{
  width:180px;
}


/* header atas (judul + filter) */
.header-bar{
  display:flex;
  align-items:center;        /* kunci kelurusan vertikal */
  justify-content:space-between;
  margin-bottom:4px;         /* jarak ke tabel */
}

.header-right{
  display:flex;
  align-items:center;
  gap:6px;
}

/* samakan tinggi filter dengan header tabel */
.header-right select,
.header-right input{
  height:32px;
  padding:4px 8px;
  font-size:12px;
}

/* supaya tidak turun-turun */
.header-right input{
  min-width:200px;
}


/* table */
.table th{
  font-size:12px;
  text-transform:uppercase;
}
.table tbody tr:hover{
  background:#f8f9fc;
}

/* percent badge */
.percent{
  padding:2px 7px;
  border-radius:6px;
  font-size:11px;
  font-weight:600;
}
.card + .card{
  margin-top:6px;
}
.filter-wrap{
  margin-bottom:2px;
}


.percent.ok{background:#d1e7dd;color:#0f5132}
.percent.mid{background:#fff3cd;color:#664d03}
.percent.low{background:#f8d7da;color:#842029}

/* pagination */
.pagination{
  gap:4px;
}
.pagination button{
  border:none;
  background:#fff;
  border-radius:6px;
  padding:4px 10px;
  font-size:12px;
  box-shadow:0 1px 4px rgba(0,0,0,.1);
}
.pagination button.active{
  background:var(--primary);
  color:#fff;
}
</style>
</head>

<body>

<div class="container mt-4">
<div class="header-bar">
  <div class="page-title">
    <i class="bi bi-bullseye text-primary fs-3"></i>
    <h4 class="m-0">Target Kegiatan / Bulan</h4>
  </div>

  <div class="header-right">

  <div class="filter-item">
    <i class="bi bi-calendar3"></i>
    <select id="month">
      <option value="">Semua Bulan</option>
      <?php
      $bulan=["","Januari","Februari","Maret","April","Mei","Juni","Juli","Agustus","September","Oktober","November","Desember"];
      for($m=1;$m<=12;$m++) echo "<option value='$m'>{$bulan[$m]}</option>";
      ?>
    </select>
  </div>

  <div class="filter-item">
    <i class="bi bi-search"></i>
    <input id="search" placeholder="Cari kegiatan...">
  </div>

</div>

  </div>

</div>

  <div class="card">
    <div class="table-responsive">
      <table class="table table-bordered table-striped align-middle mb-0">
        <thead class="table-dark text-center">
          <tr>
            <th width="50">No</th>
            <th>Nama Kegiatan</th>
            <th>Sub</th>
            <th width="120">Bulan</th>
            <th width="110" class="text-end">Target</th>
            <th width="110" class="text-end">Realisasi</th>
            <th width="90">Capaian(%)</th>
          </tr>
        </thead>
        <tbody id="tbody"></tbody>
      </table>
    </div>
  </div>

  <div class="pagination d-flex justify-content-center mt-3" id="pagination"></div>

</div>

<script>
const bulanNama=["","Januari","Februari","Maret","April","Mei","Juni","Juli","Agustus","September","Oktober","November","Desember"];
const tbody=document.getElementById('tbody');
const searchEl=document.getElementById('search');
const monthEl=document.getElementById('month');
const paginationEl=document.getElementById('pagination');

let allData=[],currentPage=1;
const perPage=10;

async function loadData(){
  const p=new URLSearchParams({action:'list'});
  if(monthEl.value) p.append('month',monthEl.value);
  if(searchEl.value.trim()) p.append('search',searchEl.value.trim());

  const r=await fetch('targetkegiatan.php?'+p.toString());
  allData=await r.json();
  currentPage=1;
  render();
}

function render(){
  let start=(currentPage-1)*perPage;
  let slice=allData.slice(start,start+perPage);
  let html='';

  slice.forEach((r,i)=>{
    let t=r.target_volume||0, real=r.realisasi||0;
    let cap=t?Math.round(real/t*100)+'%':'-';
    let bln=r.month?bulanNama[r.month]+' '+r.year:'-';

    html+=`<tr>
      <td class="text-center">${start+i+1}</td>
      <td>${esc(r.activity_name)}</td>
      <td>${r.sub_activity_name||'-'}</td>
      <td class="text-center">${bln}</td>
      <td class="text-end">${t||'-'}</td>
      <td class="text-end">${real}</td>
      <td class="text-center">
        <span class="percent ${
          cap==='-'?'':parseInt(cap)>=80?'ok':parseInt(cap)>=50?'mid':'low'
        }">${cap}</span>
      </td>
    </tr>`;
  });

  tbody.innerHTML=html||'<tr><td colspan="7" class="text-center">Tidak ada data</td></tr>';
  renderPagination();
}

function renderPagination(){
  let totalPages = Math.ceil(allData.length / perPage);
  if(totalPages <= 1){
    paginationEl.innerHTML = '';
    return;
  }

  let html = '';

  // prev
  html += `<button ${currentPage==1?'disabled':''} onclick="goto(${currentPage-1})">
            &laquo;
          </button>`;

  let start = Math.max(1, currentPage - 1);
  let end   = Math.min(totalPages, start + 2);

  if(end - start < 2){
    start = Math.max(1, end - 2);
  }

  for(let i=start;i<=end;i++){
    html += `<button class="${i==currentPage?'active':''}" onclick="goto(${i})">${i}</button>`;
  }

  // next
  html += `<button ${currentPage==totalPages?'disabled':''} onclick="goto(${currentPage+1})">
            &raquo;
          </button>`;

  paginationEl.innerHTML = html;
}


function goto(p){currentPage=p;render();}
function esc(s){return s?s.replace(/[&<>"']/g,m=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[m])):'';}

searchEl.addEventListener('input',loadData);
monthEl.addEventListener('change',loadData);

loadData();
</script>

</body>
</html>
