<?php
require_once 'config.php';

function json($data){
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

/* ================= API ================= */
if(isset($_GET['action'])){

    // Ambil total target dan realisasi per tim
    if($_GET['action']=='list'){
        $sql="SELECT t.id, t.name,
              SUM(am.target_volume) AS total_target,
              IFNULL(SUM(de.volume_today),0) AS total_realisasi
              FROM teams t
              LEFT JOIN activity_master am ON am.team_id=t.id
              LEFT JOIN daily_entries de ON de.activity_master_id=am.id
              GROUP BY t.id, t.name
              ORDER BY t.name";

        $r = mysqli_query($conn, $sql);
        $d = mysqli_fetch_all($r, MYSQLI_ASSOC);
        json($d);
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Total Target per Tim</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
    font-size:12px;
    background:#f4f6f9;
}
.container{
  width:100%;
  max-width: min(3840px, 98vw);
  padding-left:12px;
  padding-right:12px;
}h4{
    font-size:18px;
    font-weight:600;
}
.subtitle{
    font-size:12px;
    color:#6c757d;
    margin-top:-5px;
}
.card{
    border-radius:10px;
    box-shadow:0 3px 10px rgba(0,0,0,0.05);
}
.summary-label{
    font-size:11px;
    color:#6c757d;
}
.summary-value{
    font-size:28px;
    font-weight:700;
    line-height:1.1;
}
.table th{
    background:#0d6efd;
    color:white;
    font-size:12px;
    padding:7px;
}
.table td{
    font-size:12px;
    padding:7px;
    vertical-align:middle;
}
.progress{
    height:10px;
    border-radius:6px;
}
</style>
</head>

<body>
<div class="container mt-3">

<!-- TITLE -->
<div class="mb-3">
    <h3 class="mb-1">
        <i class="bi bi-bar-chart-line-fill text-primary"></i>
        Total Target Tim
    </h3>
    <div class="subtitle">Ringkasan target dan realisasi</div>
</div>

<!-- SUMMARY CARDS -->
<div class="row g-2 mb-3 text-center">
    <div class="col-4">
        <div class="card p-2">
            <div class="summary-label">Total Target</div>
            <div id="sumTarget" class="summary-value text-primary">0</div>
        </div>
    </div>
    <div class="col-4">
        <div class="card p-2">
            <div class="summary-label">Total Realisasi</div>
            <div id="sumRealisasi" class="summary-value text-success">0</div>
        </div>
    </div>
    <div class="col-4">
        <div class="card p-2">
            <div class="summary-label">Capaian</div>
            <div id="avgCapaian" class="summary-value">0%</div>
        </div>
    </div>
</div>

<!-- TABLE -->
<div class="table-responsive">
<table class="table table-bordered table-hover mb-0">
<thead class="text-center">
<tr>
<th width="40">No</th>
<th>Nama Tim</th>
<th width="120">Target</th>
<th width="120">Realisasi</th>
<th width="220">Capaian</th>
</tr>
</thead>
<tbody id="data"></tbody>
</table>
</div>
</div>

<script>
let rawData=[];
const fmt = v => Number(v||0).toLocaleString('id-ID');

async function loadTable(){
    let r = await fetch('totaltarget.php?action=list');
    rawData = await r.json();
    updateSummary();
    renderTable();
}

function updateSummary(){
    let t=0,r=0;
    rawData.forEach(x=>{
        t+=Number(x.total_target||0);
        r+=Number(x.total_realisasi||0);
    });
    let avg = t?Math.round((r/t)*100):0;
    sumTarget.innerText=fmt(t);
    sumRealisasi.innerText=fmt(r);
    avgCapaian.innerText=avg+'%';
}

function renderTable(){
    let h='',i=1;
    rawData.forEach(x=>{
        let target = Number(x.total_target||0);
        let real = Number(x.total_realisasi||0);
        let p = target?Math.round((real/target)*100):0;
        let color = p>=100?'bg-success':(p>=51?'bg-primary':'bg-danger');
        h+=`
        <tr>
            <td class="text-center">${i++}</td>
            <td>${x.name}</td>
            <td class="text-end">${fmt(target)}</td>
            <td class="text-end">${fmt(real)}</td>
            <td>
                <div class="d-flex align-items-center gap-2">
                    <div style="width:45px" class="fw-bold">${p}%</div>
                    <div class="progress w-100">
                        <div class="progress-bar ${color}" style="width:${Math.min(p,100)}%"></div>
                    </div>
                </div>
            </td>
        </tr>`;
    });
    document.getElementById('data').innerHTML = h;
}

loadTable();
</script>

</body>
</html>
